// JavaScript Document
$(document).ready(function () {
	getServiceCategoryList();
});

function getServiceCategoryList()
{
	var page = 1;
	if($('#page').length)
	{
		page = $('#page').val();	
	}	
	var search_svc_cat_name =  $("#search_svc_cat_name").val();
	if (typeof search_svc_cat_name === 'undefined')
		var new_search_svc_cat_name = '';
	else
		var new_search_svc_cat_name = search_svc_cat_name;

	var search_active =  $("#search_active").val();
	if (typeof search_active === 'undefined')
		var search_active = '';
	else
		var search_active = search_active;

	let search_svc_cat_user =  $("#search_svc_cat_user").val();
	let search_svc_cat_dt =  $("#search_svc_cat_dt").val();
	
	$.ajax({
		type:'POST',
		url: SYSLINK+'service_categories.php',
		data:{todo: 'getServiceCategoryList',page:$('#page').val(),
					search_svc_cat_name:new_search_svc_cat_name, 
					search_svc_cat_user: search_svc_cat_user, search_svc_cat_dt:search_svc_cat_dt,
					search_active:search_active},
		dataType:"json",
		success:function (data) {
			$('#divServiceCategoryList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}

function searchServiceCategoryList()
{
	$('#page').val(1);
 	getServiceCategoryList();
}

function clearServiceCategorySearch()
{
	$('#search_svc_cat_name').val('');
	$('#search_svc_cat_user').val('');
	$('#search_svc_cat_dt').val('');
	$('#page').val(1);
 	getServiceCategoryList();	
}
function addEditServiceCategory(svc_cat_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'service_categories.php',
		data:{todo: 'addEditServiceCategory', svc_cat_id:svc_cat_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
		  /////////////////
			jQuery.validator.addMethod("checkUniqueServiceCategoryDescription", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'service_categories.php',
								data: {todo:"checkUniqueServiceCategoryDescription", svc_cat_name:value, svc_cat_id: $('#svc_cat_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
								
								
							});
					return resret;
				}
			}, "Service category with same name already exists in system. Please try another.");
			
			$("#frmAddEditServiceCategory").validate({
				rules: {
					debug: true,
					   svc_cat_name:
					{
						required: true,
						checkUniqueServiceCategoryDescription:true
					}
				},
				messages: {
					svc_cat_name:
					{
						required: 'Please enter service category name'
					}
				}
			});
		}
	});
	
}

function saveServiceCategory()
{
	if($('#frmAddEditServiceCategory').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'service_categories.php',
			data:$('#frmAddEditServiceCategory').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getServiceCategoryList();
					lobinotify('success', "Service category saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
					
				}
			}
		});
	}
}

