// JavaScript Document
$(document).ready(function () {
	getEmailTemplateList();
});

function getEmailTemplateList()
{
	$('#refresh').html('<i class="icon-refresh"></i> Loading...');
	
	let search_et_name =  $("#search_et_name").val();
	let search_et_subject =  $("#search_et_subject").val();
	let search_et_active = $('#search_et_active').val();

	$.ajax({
		type:'POST',
		url: SYSLINK+'email_templates.php',
		data:{todo: 'getEmailTemplateList', search_et_name:search_et_name, 
				search_et_subject:search_et_subject,
				search_et_active:search_et_active, page:$('#page').val()},
		dataType:"json",
		success:function (data) {
			$('#refresh').html("");
			$('#divEmailTemplateList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}

function searchEmailTemplateList()
{
	$('#page').val(1);
 	getEmailTemplateList();
}
function clearEmailTemplateSearch()
{
	$("#search_et_name").val('');
	$("#search_et_subject").val('');
	$("#search_et_active").val('');
	$('#page').val(1);
	getEmailTemplateList();	
}
function addEditEmailTemplate(et_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'email_templates.php',
		data:{todo: 'addEditEmailTemplate', et_id:et_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			$('#et_description').summernote({height: 300, dialogsInBody: true});

			jQuery.validator.addMethod("checkUniqueEmailTemplateName", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'email_templates.php',
								data: {todo:"checkUniqueEmailTemplateName", et_name:value, et_id: $('#et_id').val()},
								dataType:"json",
								success:function (data) {
		
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
							});
					return resret;
				}
			}, "Email Template with same name already exists in system. Please try another.");
			$("#frmAddEditEmailTemplate").validate({
				rules: {
					debug: true,
					et_name:
					{
						required: true,
						checkUniqueEmailTemplateName:true
					},
					et_subject:
					{
						required: true
					}
				},
				messages: {
					et_name:
					{
						required: "Please enter email template name"
					},
					et_subject:
					{
						required: "Please enter email subject"
					}
				}
			});
		}
	});
}

function saveEmailTemplate()
{
	if($('#frmAddEditEmailTemplate').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'email_templates.php',
			data:$('#frmAddEditEmailTemplate').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getEmailTemplateList();
					lobinotify('success', "Email Template saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}

