// JavaScript Document
var addr_fields = ["addr1", "addr2", "town", "county", "postcode"];
$(document).ready(function () {
	getViewCompanyList();

	
});


function getViewCompanyList()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'company_view.php',
		data:{todo: 'getViewCompanyList'},
		dataType:"html",
		success:function (data) {
			$('#tabCompanyOverview').html(data);
		}
	});
}

function addEditCompany()
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'company_view.php',
		data:{todo: 'addEditCompany'},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			var select = $('#tradeTypeIds').select2();
			jQuery.validator.addMethod("checkUniqueCompanyName", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'company_view.php',
								data: {todo:"checkUniqueCompanyName", company_name:value},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
								
								
							});
					return resret;
				}
			}, "Company Email Already Exist in system. Please try another.");
			
			$("#frmAddEditCompany").validate({
				rules: {
					debug: true,
					   company_name:
					{
						required: true,
						checkUniqueCompanyName:true
					},
					business_type:
					{
						required: true
					},
					postcode:
					{
						required: true
					},
					addr1:
					{
						required: true
					},
					town:
					{
						required: true
					},
					state:
					{
						required: true
					},
					email:
					{
						required: true,
						email:true
					},
					phone:
					{
						required: true,
						number:true
					},
					mobile:
					{
						required: true,
						number:true
					},
					website:{
						/*url: true*/
					}
				},
				messages: {
					company_name:
					{
						required: 'Please enter Name'
					},
					business_type:
					{
						required: 'Please select Company Type'
					},
					postcode:
					{
						required: 'Please enter Postcode'
					},
					addr1:
					{
						required: 'Please enter Address 1'
					},
					town:
					{
						required: 'Please enter Town'
					},
					email:
					{
						required: 'Please enter Email'
					},
					phone:
					{
						required: 'Please enter Phone'
					},
					mobile:
					{
						required: 'Please enter Mobile'
					}
				}
			})
			pca.load();
		}
	});
	
}

function saveCompany()
{
	if($('#frmAddEditCompany').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'company_view.php',
			data:$('#frmAddEditCompany').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getViewCompanyList();
					lobinotify('success', "Company data saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.")
				}
			}
		});
	}
}
function editCompanyLogo(company_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'company_view.php',
		data:{todo: 'editCompanyLogo',company_id:company_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			//File Mime Type Validation
			checkFileImageType('company_logo')
		}
	});
}
function saveCompanyLogo()
{
	//if($('#frmProfilePic').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		var frmCompanyLogo = $("#frmCompanyLogo");
		var formData = new FormData($('#frmCompanyLogo')[0]);
		$.ajax({
			type:'POST',
			url: SYSLINK+'company_view.php',
			data:frmCompanyLogo,
			data: formData,
			dataType:"json",
			mimeType:"multipart/form-data",
			processData: false,
			contentType: false,
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					//getViewCompanyList();
					$('#companyLogo').html(data.company_logo_html);
					lobinotify('success', "Company logo image saved successfully.");

					const imgLogo = document.getElementById('imgLogo');
					console.log(imgLogo.src);
					imgLogo.src = SYSLINK+'get_company_logo.php?rand=' + new Date().getTime(); // Triggers a reload
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}
function saveCompanyAppointmentSettings()
{

	let wst = $('#work_start_at').val();
	let wet = $('#work_end_at').val();

	let bst = $('#break_start_at').val();
	let bet = $('#break_end_at').val();

	if((wst != '' && wet == '') || (wst == '' && wet != '')){
		alert('Both work start time and work end time should have valid time value');
		return false;
	}

	if((bst != '' && bet == '') || (bst == '' && bet != '')){
		alert('Both break start time and break end time should have valid time value');
		return false;
	}

	if(wst != '' && wet != ''){
		let iwst = wst.replace(':','');
		let iwet = wet.replace(':', '');

		let diff = parseInt(iwet) - parseInt(iwst);

		if(diff < 0){
			alert('Work start time should be less than work end time');
			return false;
		}
	}

	if(bst != '' && bet != ''){
		let ibst = bst.replace(':','');
		let ibet = bet.replace(':', '');

		let diff = parseInt(ibet) - parseInt(ibst);

		if(diff < 0){
			alert('Break start time should be less than break end time');
			return false;
		}
	}

	$('#btnSaveCas').hide();
	$('#btnWaitCas').show();
	$.ajax({
		type:'POST',
		url: SYSLINK+'company_view.php',
		data:$('#frmCompanyAppointmentSettings').serialize(),
		dataType:"json",
		success:function (data) {
			if(data.result == 'Success')
			{
				
				lobinotify('success', "Company appointment settings saved successfully.");
			}
			else
			{
				lobinotify('error', "Sorry, some problem occurred while saving data.")
			}
			$('#btnWaitCas').hide();
			$('#btnSaveCas').show();
			
		}
	});
}

