// JavaScript Document
$(document).ready(function () {
	if($('.page-title-box').data("pg") === 'rolelist'){
		getUserRoleList();
	}
});

function getUserRoleList()
{
	$('#refresh').html('<i class="icon-refresh"></i> Loading...');
	
	let search_role =  $("#search_role").val();
	let search_active =  $("#search_active").val();
	
	$.ajax({
		type:'POST',
		url: SYSLINK+'user_roles.php',
		data:{todo: 'getUserRoleList',search_role:search_role, search_active:search_active, page:$('#page').val()},
		dataType:"json",
		success:function (data) {
			$('#refresh').html("");
			$('#divUserRoleList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}
function searchUserRoleList()
{
	$('#page').val(1);
 	getUserRoleList();
}
function clearUserRoleSearch()
{
	$("#search_role").val("");
	$("#search_active").val("");
	$('#page').val(1);
	getUserRoleList();	
}
function addEditUserRole(role_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'user_roles.php',
		data:{todo: 'addEditUserRole', user_role_id:role_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
		  //////////////////////////////
			jQuery.validator.addMethod("checkUniqueUserRole", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'user_roles.php',
								data: {todo:"checkUniqueUserRole", role_desc:value, user_role_id: $('#user_role_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
							});
					return resret;
				}
			}, "User Role already exists in system. Please try another.");
			$("#frmAddEditUserRole").validate({
				rules: {
					debug: true,
					role_desc:{
						required: true,
						checkUniqueUserRole:true
					}
				},
				messages: {
					role_desc:{
						required: 'Please enter role description'
					}
				}
			});
		}
	});	
	
}

function saveUserRole()
{
	if($('#frmAddEditUserRole').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'user_roles.php',
			data:$('#frmAddEditUserRole').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getUserRoleList();
					
					lobinotify('success', "User Role saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}
