// JavaScript Document
$(document).ready(function () {
	getUserViewList();
	$('#email_sign').summernote({height: 300, dialogsInBody: true});
	let buttons = $('.note-editor button[data-toggle="dropdown"]');
    buttons.each(function (index) { $(this).removeAttr("data-toggle").attr("data-bs-toggle", "dropdown"); });
});

function getURLParameter(name) {
    return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null;
}

function getUserViewList()
{
	$('#refresh').html('<i class="icon-refresh"></i> Loading...');

	$.ajax({
		type:'POST',
		url: SYSLINK+'user_profile.php',
		data:{todo: 'getUserViewList'},
		dataType:"json",
		success:function (data) {
			$('#refresh').html("");
			$('#tabOverview').html(data.list_html);
		}
	});
}

function editProfilePic(user_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'user_profile.php',
		data:{todo: 'editProfilePic'},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
		}
	});	
}

function saveUserProfilePic()
{
	//if($('#frmProfilePic').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		var formData = new FormData($('#frmProfilePic')[0]);
		$.ajax({
			type:'POST',
			url: SYSLINK+'user_profile.php',
			data: formData,
			dataType:"json",
			mimeType:"multipart/form-data",
			processData: false,
			contentType: false,
			success:function (data) {
				if(data.result === 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getUserViewList(false);
					lobinotify('success', "Profile pic saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}

function saveEmailSignature()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'user_profile.php',
		data:{todo: 'saveEmailSignature', user_id:$('#user_id').val(), email_sign: $('#email_sign').summernote('code')},
		dataType:"json",
		success:function (data) {
			if(data.result === 'Success')
			{
				lobinotify('success', "Email signature saved successfully !!!");
			}
			else
			{
				lobinotify('error', "Sorry, some problem occurred while saving data.");
			}
		}
	});

}
