// JavaScript Document
$(document).ready(function () {
	if($('.page-title-box').data("pg") === 'servicelist'){
		getServiceList();
	}
});

function getServiceList()
{
	$('#refresh').html('<i class="icon-refresh"></i> Loading...');
	
	let search_svc_name =  $("#search_svc_name").val();
	let search_svc_cat =  $("#search_svc_cat").val();
	let search_svc_user =  $("#search_svc_user").val();
	let search_svc_dt =  $("#search_svc_dt").val();
	let search_active = $('#search_active').val();

	$.ajax({
		type:'POST',
		url: SYSLINK+'services.php',
		data:{todo: 'getServiceList', search_svc_name:search_svc_name, search_svc_cat:search_svc_cat,
					search_svc_user:search_svc_user, search_svc_dt:search_svc_dt,
				 search_active:search_active, page:$('#page').val()},
		dataType:"json",
		success:function (data) {
			$('#refresh').html("");
			$('#divServiceList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}

function searchServiceList()
{
	$('#page').val(1);
 	getServiceList();
}
function clearServiceSearch()
{
	$("#search_svc_name").val('');
	$("#search_svc_cat").val('');
	$("#search_svc_user").val('');
	$("#search_svc_dt").val('');
	$("#search_active").val('');
	$('#page').val(1);
	getServiceList();	
}
function addEditService(svc_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'services.php',
		data:{todo: 'addEditService', svc_id:svc_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			$( '#fk_svc_cat_id' ).select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
				dropdownParent: $("#fk_svc_cat_id").parent(),
			} );

			$.fn.modal.Constructor.prototype.enforceFocus = function() {};

			//////////////////////////////
			jQuery.validator.addMethod("checkUniqueServiceName", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					let catid = $('#fk_svc_cat_id').val();
					if(catid == ''){
						catid = 0;
					}
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'services.php',
								data: {todo:"checkUniqueServiceName", svc_name:value, svc_id: $('#svc_id').val(), svc_cat_id:catid},
								dataType:"json",
								success:function (data) {
		
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
							});
					return resret;
				}
			}, "Service with same name already exists in system. Please try another.");
			$("#frmAddEditService").validate({
				rules: {
					debug: true,
					svc_name:
					{
						required: true,
						checkUniqueServiceName:true
					}
					
				},
				messages: {
					svc_name:
					{
						required: "Please enter service name"
					}
				}
			});
		}
	});
}

function saveService()
{
	if($('#frmAddEditService').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'services.php',
			data:$('#frmAddEditService').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					if($('.page-title-box').data("pg") === 'servicelist'){
						getServiceList();
					}else{
						getServiceOverview();
					}
					
					lobinotify('success', "Service saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}

function setServiceSalePrice(pscl=0)
{
	if(pscl){
		if($.trim($('#pscl_cost_price').val()) != '' && $.trim($('#svc_profit_margin').val()) != ''){
			let pscl_cost_price = parseFloat($('#pscl_cost_price').val());
			let svc_profit_margin = parseFloat($('#svc_profit_margin').val());
			let pscl_sale_price = 0;
	
			if(pscl_cost_price > 0 && svc_profit_margin >=0){
				pscl_sale_price = Math.round((pscl_cost_price + (svc_profit_margin * pscl_cost_price / 100)),2);
				$('#pscl_sale_price').val(pscl_sale_price);
			}
		}
	}else{
		if($.trim($('#ps_cost_price').val()) != '' && $.trim($('#svc_profit_margin').val()) != ''){
			let ps_cost_price = parseFloat($('#ps_cost_price').val());
			let svc_profit_margin = parseFloat($('#svc_profit_margin').val());
			let ps_sale_price = 0;
	
			if(ps_cost_price > 0 && svc_profit_margin >=0){
				ps_sale_price = Math.round((ps_cost_price + (svc_profit_margin * ps_cost_price / 100)),2);
				$('#ps_sale_price').val(ps_sale_price);
			}
		}
	}
	
}

function getServiceOverview()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'service_view.php',
		data:{todo: 'getServiceOverview', service_id:$('#service_id').val()},
		dataType:"html",
		success:function (data) {
			$('#tabServiceOverview').html(data);
			
		}
	});
}

function getServiceSupplierList()
{
	let search_supplier =  $("#search_supplier").val();
	let search_part =  $("#search_part").val();
	let search_cost =  $("#search_cost").val();
	let search_sale = $('#search_sale').val();
	let search_date = $('#search_effective_date').val();

	$.ajax({
		type:'POST',
		url: SYSLINK+'service_view.php',
		data:{todo: 'getServiceSupplierList', service_id:$('#service_id').val(),
				search_supplier:search_supplier, search_part:search_part, search_cost:search_cost, 
				search_sale:search_sale, search_date:search_date},
		dataType:"json",
		success:function (data) {
			$('#tbdServiceSupplierList').html(data.list_html);
		}
	});
}
function searchServiceSupplierList()
{
	
	getServiceSupplierList();
}
function clearServiceSupplierSearch()
{
	$("#search_supplier").val('');
	$("#search_part").val('');
	$("#search_cost").val('');
	$("#search_sale").val('');
	$("#search_effective_date").val('');
	$('#page').val(1);
	getServiceSupplierList();	
}

function addEditServiceSupplier(ps_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'service_view.php',
		data:{todo: 'addEditServiceSupplier', ps_id:ps_id, service_id:$('#service_id').val()},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			$('#spnPrdCppm').html($('#svc_profit_margin').val());

			$.fn.modal.Constructor.prototype.enforceFocus = function() {};

			//////////////////////////////
			/*jQuery.validator.addMethod("checkUniqueServiceSupplier", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'service_view.php',
								data: {todo:"checkUniqueServiceSupplier", service_id: $('#service_id').val(), supplier_id:value},
								dataType:"json",
								success:function (data) {
		
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
							});
					return resret;
				}
			}, "Supplier is already assigned to this service. Please try another.");*/
			$("#frmAddEditServiceSupplier").validate({
				rules: {
					debug: true,
					fk_supplier_id:
					{
						required: true,
						//checkUniqueServiceSupplier:true
					},
					ps_part_number:
					{
						required: true
					},
				},
				messages: {
					fk_supplier_id:
					{
						required: "Please select supplier"
					},
					ps_part_number:
					{
						required: "Please enter part number"
					},
				}
			});
		}
	});
}

function saveServiceSupplier()
{
	if($('#frmAddEditServiceSupplier').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'service_view.php',
			data:$('#frmAddEditServiceSupplier').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getServiceSupplierList();
					
					lobinotify('success', "Supplier assigned to service successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}

function manageServiceSupplierCost(ps_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'service_view.php',
		data:{todo: 'manageServiceSupplierCost', ps_id:ps_id, service_id:$('#service_id').val()},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			$('#spnPrdCppm').html($('#svc_profit_margin').val());

			$.fn.modal.Constructor.prototype.enforceFocus = function() {};

			$("#frmAddEditServiceSupplierCost").validate({
				rules: {
					debug: true,
					pscl_effective_date:
					{
						required: true,
						//checkUniqueServiceSupplier:true
					},
					pscl_cost_price:
					{
						required: true,
						number: true
						
					},
					pscl_sale_price:
					{
						required: true,
						number: true
					},
				},
				messages: {
					pscl_effective_date:
					{
						required: "Please select date"
					},
					pscl_cost_price:
					{
						required: "Please enter cost price"
					},
					pscl_sale_price:
					{
						required: "Please enter sale price"
					}
				}
			});
		}
	});
}
function editPoductSupplierCost(pscl_id)
{
	let cval = $('#pcl_'+pscl_id).val();

	let arrpscl = cval.split("|");

	$('#pscl_id').val(pscl_id);
	$('#pscl_effective_date').val(arrpscl[0]);
	$('#pscl_cost_price').val(arrpscl[1]);
	$('#pscl_sale_price').val(arrpscl[2]);

}

function resetPsclForm()
{
	$('#frmAddEditServiceSupplierCost')[0].reset();
	$('#pscl_id').val(0);
	
}

function saveServiceSupplierCost()
{
	if($('#frmAddEditServiceSupplierCost').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'service_view.php',
			data:$('#frmAddEditServiceSupplierCost').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					
					$('#btnWait').hide();
					$('#btnSave').show();
					resetPsclForm();
					getServiceSupplierCostList();
					getServiceSupplierList();
					
					lobinotify('success', "Supplier cost assigned to service successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}
function getServiceSupplierCostList()
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'service_view.php',
		data:{todo: 'getServiceSupplierCostList', service_id:$('#fk_service_id').val(), supplier_id:$('#fk_supplier_id').val()},
		dataType: "html",
		success: function (data) {
			$('#divProdSupCostList').html(data);
			}
	});
}