// JavaScript Document
$(document).ready(function () {
	if($('.page-title-box').data("pg") === 'bsdoc'){
		getBookShelfDocList();
	}
});

function getBookShelfDocList()
{
	
	var page = 1;
	if($('#page').length)
	{
		page = $('#page').val();	
	}	
	var search_name =  $("#search_name").val();
	if (typeof search_name === 'undefined')
		var new_search_name = '';
	else
		var new_search_name = search_name;
	
	var search_author =  $("#search_author").val();
	if (typeof search_author === 'undefined')
		var new_search_author = '';
	else
		var new_search_author = search_author;
		
	var search_date =  $("#search_date").val();
	if (typeof search_date === 'undefined')
		var new_search_date = '';
	else
		var new_search_date = search_date;
		
	var search_version =  $("#search_version").val();
	if (typeof search_version === 'undefined')
		var new_search_version = '';
	else
		var new_search_version = search_version;
	
	var search_bscat_id =  $("#search_bscat_id").val();
	if (typeof search_bscat_id === 'undefined')
		var new_search_bscat_id = '';
	else
		var new_search_bscat_id = search_bscat_id;
		
    $.ajax({
        type:'POST',
        url: SYSLINK+'bookshelf_docs.php',
        data:{todo: 'getBookShelfDocList',page:$('#page').val(),search_name:new_search_name,search_author:new_search_author,search_date:new_search_date,search_version:new_search_version,search_bscat_id:new_search_bscat_id},
        dataType:"json",
        success:function (data) {
			$('#divBookShelfDocList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
        }
    });
}
function searchBookShelfDocList()
{
	$('#page').val(1);
 	getBookShelfDocList();
}
function clearBookShelfDocSearch()
{
	$('#search_name').val('');
	$('#search_author').val('');
	$('#search_date').val('');
	$('#search_version').val('');
	$('#search_bscat_id').val('');
	$('#page').val(1);
 	getBookShelfDocList();	
}
function addEditBookShelfDoc(bsdoc_id)
{
	$.when(
		$.getScript(SYSLINK + 'web/javascripts/plugins/validate/jquery.validate.min.js'),
		$.Deferred(function(deferred) {
			$(deferred.resolve);	
		})
	).done(function(){
		$.ajax({
			type: 'POST',
			url: SYSLINK+'bookshelf_docs.php',
			data:{todo: 'addEditBookShelfDoc', bsdoc_id:bsdoc_id},
			dataType: "html",
			success: function (data) {
				$('#divModal').html(data);
				$('#divModal').modal('show');

				//File Mime Type Validation
				checkFileMimeType('bsdoc_file')

				$("#frmAddEditBookShelfDoc").validate({
					rules: {
						debug: true,
					   	
						bsdoc_bscat_id:
						{
							required: true
						},
						bsdoc_name:
						{
							required: true
						},
						bsdoc_auth_by:
						{
							required: true
						},
						bsdoc_date:
						{
							required: true
						},
						bsdoc_version:
						{
							required: true
						},
						bsdoc_pages:
						{
							required: true
						},
						bsdoc_location:
						{
							required: true
						},
						bsdoc_file:
						{
							required: function(){if($('#bsdoc_id').val() == '0'){return true}else{return false}},

						}
						
					},
					messages: {
						fk_bscat_id:
						{
							required: 'Please select document category'
						},
						bsdoc_name:
						{
							required: 'Please enter name'
						},
						bsdoc_auth_by:
						{
							required: 'Please enter author name'
						},
						bsdoc_date:
						{
							required: 'Please enter date'
						},
						bsdoc_version:
						{
							required: 'Please enter version'
						},
						bsdoc_pages:
						{
							required: 'Please enter total pages'
						},
						bsdoc_location:
						{
							required: 'Please enter location'
						},
						bsdoc_file:
						{
							required: 'Please select document to upload'
						}
					}
				});
			}
    	});
	});	
	
}
function saveBookShelfDoc()
{
	if($('#frmAddEditBookShelfDoc').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		var frmAddEditBookShelfDoc = $("#frmAddEditBookShelfDoc");
		var formData = new FormData($('#frmAddEditBookShelfDoc')[0]);
		$.ajax({
			type:'POST',
			url: SYSLINK+'bookshelf_docs.php',
			data: formData,
			mimeType:"multipart/form-data",
			processData: false,
			contentType: false,
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getBookShelfDocList();
					lobinotify('success', "Bookshelf document saved successfully.");
				}
				else
				{
					alert('Sorry, some problem occurred while saving data');	
				}
			}
		});
	}
}

function checkBscatId()
{
	if($.trim($('#fk_bscat_id').val()) === 'new'){
		addEditBookshelfCategory(0)
	}
}