// JavaScript Document
$(document).ready(function () {
	getEmailTemplateList();
});

function getEmailTemplateList()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'admin/email_template.php',
		data:{todo: 'getEmailTemplateList'},
		dataType:"html",
		success:function (data) {
			$('#divEmailTemplateList').html(data);
		}
	});
}

function addEditEmailTemplate(et_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'admin/email_template.php',
		data:{todo: 'addEditEmailTemplate', et_id:et_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			$('.wysihtml5').wysihtml5();
			
		
			jQuery.validator.addMethod("checkUniqueEmailTemplateName", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'admin/email_template.php',
								data: {todo:"checkUniqueEmailTemplateName", et_name:value, et_id: $('#et_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
								
								
							});
					return resret;
				}
			}, "EmailTemplate Name Already Exist in system. Please try another.");
			
			$("#frmAddEditEmailTemplate").validate({
				rules: {
					debug: true,
					   et_name:
					{
						required: true,
						checkUniqueEmailTemplateName:true
					},
					et_subject:
					{
						required: true
					},
					et_description:
					{
						required: true,
					}
				},
				messages: {
					et_name:
					{
						required: 'Please enter Email Template Name'
					},
					et_subject:
					{
						required: 'Please enter Email Template Subject'
					},
					et_description:
					{
						required: 'Please enter Email Template Description'
					}
				}
			});
		}
	});
	
}

function saveEmailTemplate()
{
	if($('#frmAddEditEmailTemplate').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'admin/email_template.php',
			data:$('#frmAddEditEmailTemplate').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getEmailTemplateList();
					lobinotify('success', "Email template saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}
function deleteEmailTemplate(et_id)
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete this email template?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:"POST",
					url: SYSLINK +'admin/email_template.php',
					data:{todo:"deleteEmailTemplate",et_id:et_id},
					dataType:"json",
					success:function (data) {
						if(data.result == "Success")
						{
							getEmailTemplateList();
							lobinotify('success', "Email template deleted successfully.");
						}
						else
						{
							lobinotify('error', "Sorry, some problem occurred while saving data.");
						}
					}
				 });
			}
		}
	});
}
function assignRole(et_id)
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'admin/email_template.php',
		data:{todo: 'assignRole', et_id:et_id},
		dataType:"html",
		success:function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
		}
	});
}

function saveAssignRole()
{
		$.ajax({
			type:'POST',
			url: SYSLINK+'admin/email_template.php',
			data:$('#frmAssignEmailTemplate').serialize(),
			dataType:"json",
			success:function (data) {
				
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getEmailTemplateList();
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	
}