// JavaScript Document
var addr_fields = ["addr1", "addr2", "town", "county", "postcode"];

$(document).ready(function () {
	getCompanyList();
});

function getCompanyList()
{
	var page = 1;
	

	if($('#page').length)
	{
		page = $('#page').val();	
	}	
	

	$.ajax({
		type:'POST',
		url: SYSLINK+'admin/company.php',
		data:{todo: 'getCompanyList',page:page,search_text:$('#search_text').val()},
		dataType:"html",
		success:function (data) {
			$('#divCompanyList').html(data);
			$("#total_recs").html($("#cur_rec_total").val());
		}
	});
}

function searchCompanyList()
{
	$('#page').val(1)
 	getCompanyList();
}

function clearCompanySearch()
{
	$('#search_text').val('');
	$('#page').val(1)
 	getCompanyList();	
}
function addEditCompany(company_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'admin/company.php',
		data:{todo: 'addEditCompany', company_id:company_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			var select = $('#tradeTypeIds').select2({placeholder: "Please select"});
			jQuery.validator.addMethod("checkUniqueCompanyName", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'admin/company.php',
								data: {todo:"checkUniqueCompanyName", company_name:value, company_id: $('#company_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
							});
					return resret;
				}
			}, "Company Email Already Exist in system. Please try another.");
			
			$("#frmAddEditCompany").validate({
				rules: {
					debug: true,
					company_bc_id:{
						required: true
					},
					company_name:
					{
						required: true,
						checkUniqueCompanyName:true
					},
					business_type:
					{
						required: true
					},
					postcode:
					{
						required: true
					},
					addr1:
					{
						required: true
					},
					town:
					{
						required: true
					},
					county:
					{
						required: true
					},
					email:
					{
						required: true,
						email:true
					},
					phone:
					{
						required: true,
						digits:true
					},
					
					mobile:
					{
						required: true,
						digits:true
					},
					
				},
				messages: {
					company_bc_id:{
						required: 'Please select business category'
					},
					company_name:
					{
						required: 'Please enter Name'
					},
					business_type:
					{
						required: 'Please select Company Type'
					},
					postcode:
					{
						required: 'Please enter Postcode'
					},
					addr1:
					{
						required: 'Please enter Address 1'
					},
					town:
					{
						required: 'Please enter Town'
					},
					county:
					{
						required: 'Please enter State'
					},
					email:
					{
						required: 'Please enter Email'
					},
					phone:
					{
						required: 'Please enter Phone'
					},
					mobile:
					{
						required: 'Please enter Mobile'
					}
				}
			});
		}
	});
	
}

function saveCompany()
{
	if($('#frmAddEditCompany').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'admin/company.php',
			data:$('#frmAddEditCompany').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getCompanyList();
					lobinotify('success', "Company saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}